<?php
/**
* @package XenCentral Ad Server
* @author Skydevelop EU
* @copyright Drnoyan & Nalyan LDA, Portugal, EU
* @license http://www.dnf.pt/eula.html
* @link http://www.skydevelop.com
* @revision 97
* @version 2.0.0 beta 3 rev. 3
*/

class XenCentral_AdServer_Helper_StatsInPercentage
{
    protected $from;

    protected $to;

    protected $content_type;

    protected $content_ids;

    protected $stats_type;

    public function getQuery()
    {
        $sql='';
        switch($this->stats_type)
        {
            case 'clicks':
                $sql = "
                    SELECT {$this->content_type}Id, COUNT(*) AS count
                    FROM xcas_{$this->stats_type}_{$this->content_type}
                    WHERE dateline>={$this->from}
                    AND dateline<={$this->to}
                    AND {$this->content_type}Id IN(" . implode(',', $this->content_ids) . ")
                    GROUP BY {$this->content_type}Id
                ";
                break;
            default:
                $sql= "
                    SELECT {$this->content_type}Id, SUM(count) AS count
                    FROM xcas_{$this->stats_type}_{$this->content_type}
                    WHERE dateline>={$this->from}
                    AND dateline<={$this->to}
                    AND {$this->content_type}Id IN(" . implode(',', $this->content_ids) . ")
                    GROUP BY {$this->content_type}Id
                ";
                break;
        }
        return $sql;
    }

    public function getPrimaryKey()
    {
        return $this->content_type.'Id';
    }

    public function getCountFromDataRow($dataRow)
    {
        if(!empty($dataRow['count'])) {
            return $dataRow['count'];
        }
        return 1;
    }

    public function getStatsRow($data)
    {

    }

    /**
     * @param mixed $content_ids
     */
    public function setContentIds($content_ids)
    {
        $this->content_ids = $content_ids;
    }

    /**
     * @return mixed
     */
    public function getContentIds()
    {
        return $this->content_ids;
    }

    /**
     * @param mixed $content_type
     */
    public function setContentType($content_type)
    {
        $this->content_type = $content_type;
    }

    /**
     * @return mixed
     */
    public function getContentType()
    {
        return $this->content_type;
    }

    /**
     * @param mixed $from
     */
    public function setFrom($from)
    {
        $this->from = $from;
    }

    /**
     * @return mixed
     */
    public function getFrom()
    {
        return $this->from;
    }

    /**
     * @param mixed $stats_type
     */
    public function setStatsType($stats_type)
    {
        $this->stats_type = $stats_type;
    }

    /**
     * @return mixed
     */
    public function getStatsType()
    {
        return $this->stats_type;
    }

    /**
     * @param mixed $to
     */
    public function setTo($to)
    {
        $this->to = $to;
    }

    /**
     * @return mixed
     */
    public function getTo()
    {
        return $this->to;
    }


}